/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.ammobench;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.resource.ammobench.AddRangeOutputCount;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCount;
import dev.toma.gunsrpg.resource.ammobench.MulRangeOutputCount;
import dev.toma.gunsrpg.resource.ammobench.SetRangeOutputCount;
import dev.toma.gunsrpg.resource.ammobench.WeightedRangeOutputCount;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public final class AmmoBenchOutputCountType<C extends AmmoBenchOutputCount> {
    private static final Map<ResourceLocation, AmmoBenchOutputCountType<?>> REGISTRY = new HashMap();
    public static final AmmoBenchOutputCountType<SetRangeOutputCount> SET = AmmoBenchOutputCountType.register(GunsRPG.makeResource("set"), new SetRangeOutputCount.Serializer());
    public static final AmmoBenchOutputCountType<AddRangeOutputCount> ADD = AmmoBenchOutputCountType.register(GunsRPG.makeResource("add"), new AddRangeOutputCount.Serializer());
    public static final AmmoBenchOutputCountType<MulRangeOutputCount> MUL = AmmoBenchOutputCountType.register(GunsRPG.makeResource("multiply"), new MulRangeOutputCount.Serializer());
    public static final AmmoBenchOutputCountType<WeightedRangeOutputCount> WEIGHTED = AmmoBenchOutputCountType.register(GunsRPG.makeResource("weighted_select"), new WeightedRangeOutputCount.Serializer());
    private final ResourceLocation identifier;
    private final AmmoBenchOutputCountSerializer<C> serializer;

    private AmmoBenchOutputCountType(ResourceLocation identifier, AmmoBenchOutputCountSerializer<C> serializer) {
        this.identifier = identifier;
        this.serializer = serializer;
    }

    public static <C extends AmmoBenchOutputCount> AmmoBenchOutputCountType<C> register(ResourceLocation identifier, AmmoBenchOutputCountSerializer<C> serializer) {
        AmmoBenchOutputCountType<C> type = new AmmoBenchOutputCountType<C>(identifier, serializer);
        REGISTRY.put(identifier, type);
        return type;
    }

    public static <C extends AmmoBenchOutputCount> C parseJson(JsonElement element) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(element);
        ResourceLocation type = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"type"));
        AmmoBenchOutputCountType<C> countType = AmmoBenchOutputCountType.byKey(type).orElseThrow(() -> new JsonSyntaxException("Unknown function: " + type));
        AmmoBenchOutputCountSerializer<C> serializer = countType.serializer;
        return serializer.parseJson((JsonElement)object);
    }

    public static <C extends AmmoBenchOutputCount> void toNetwork(C modifier, PacketBuffer buffer) {
        AmmoBenchOutputCountType<?> type = modifier.getType();
        buffer.func_192572_a(type.identifier);
        type.serializer.toNetwork(modifier, buffer);
    }

    public static <C extends AmmoBenchOutputCount> C fromNetwork(PacketBuffer buffer) {
        ResourceLocation identifier = buffer.func_192575_l();
        AmmoBenchOutputCountType<C> type = AmmoBenchOutputCountType.byKey(identifier).orElseThrow(() -> new IllegalStateException("Unable to synchronize unknown modifier - " + identifier));
        return type.serializer.fromNetwork(buffer);
    }

    public static <C extends AmmoBenchOutputCount> CompoundNBT toNbt(C modifier) {
        AmmoBenchOutputCountType<?> type = modifier.getType();
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("type", type.identifier.toString());
        nbt.func_218657_a("data", (INBT)type.serializer.toNbt(modifier));
        return nbt;
    }

    public static <C extends AmmoBenchOutputCount> C fromNbt(CompoundNBT nbt) {
        ResourceLocation identifier = new ResourceLocation(nbt.func_74779_i("type"));
        AmmoBenchOutputCountType<C> type = AmmoBenchOutputCountType.byKey(identifier).orElseThrow(() -> new IllegalStateException("Unable to serialize unknown modifier - " + identifier));
        return type.serializer.fromNbt(nbt.func_74775_l("data"));
    }

    public static <C extends AmmoBenchOutputCount> Optional<AmmoBenchOutputCountType<C>> byKey(ResourceLocation key) {
        return Optional.ofNullable(REGISTRY.get(key));
    }

    public static interface AmmoBenchOutputCountSerializer<C extends AmmoBenchOutputCount> {
        public C parseJson(JsonElement var1) throws JsonParseException;

        public void toNetwork(C var1, PacketBuffer var2);

        public C fromNetwork(PacketBuffer var1);

        public CompoundNBT toNbt(C var1);

        public C fromNbt(CompoundNBT var1);
    }
}

